<?php

function getInfoTicket($productsInCart, $productId) : string{
    global $wpdb;
    $listNumbers = '';

    if (count($productsInCart) > 0) {

        foreach ($productsInCart as $product) {
            $i = 0;
            $selectedTickets = '';

            $result = $wpdb->get_results("SELECT * FROM wrif_lottery_selections WHERE post_id = $productId AND ticket_number = $product");

            foreach ($result as $row) {
                $selectedTickets .= ' '. $row->number;
                if($i < count($result) - 1)
                    $selectedTickets .= ',';
                $i++;
            }

            $selectedTickets = "<li>". $product .': [' . $selectedTickets . ']</li>';

            $listNumbers .= $selectedTickets;
        }
    }

    return "<ul class='ticket-selected-list' >$listNumbers</ul>";
}

function generateDataFromCart($cart_item): void
{
    global $wpdb;
    $product = $cart_item['data'];
    $product_id = $product->get_id();
    $products_in_cart = $cart_item['lty_lottery']['tickets'];
    echo getInfoTicket($products_in_cart, $product_id);
}


add_action('woocommerce_after_cart_item_name', 'add_custom_text_after_cart_item_name', 10, 2);
function add_custom_text_after_cart_item_name($cart_item, $cart_item_key): void
{
    generateDataFromCart($cart_item);
}


function custom_data_summary_checkout($quantity, $cart_item , $cart_item_key): void
{
    generateDataFromCart($cart_item);
}

add_action('woocommerce_checkout_cart_item_quantity', 'custom_data_summary_checkout', 1, 3);

function display_message_below($display_key, $meta, $item) {
    $product_id = $item->get_product_id();
    $tickets = $item->get_meta('_lty_lottery_tickets');
    echo getInfoTicket($tickets, $product_id);
}
add_filter( 'woocommerce_order_item_display_meta_key', 'display_message_below', 20,3 );


function update_lottery_ticket_selected($order_id, $old_status, $new_status)
{
    global $wpdb;

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_id => $item ) {

        if($new_status === 'completed'){
            $productId = $item->get_product_id();
            $tickets = $item->get_meta('_lty_lottery_tickets');
            foreach ( $tickets as $ticketNumber) {
                $wpdb->update(
                    'wrif_lottery_selections',
                    array(
                        'status' => 'PAID',
                    ),
                    array(
                        'post_id' => (int) $productId,
                        'ticket_number' => (int) $ticketNumber,
                    ),
                    array(
                        '%s',
                    ),
                    array( '%d','%d' )
                );
            }
        }
    }
}

add_action('woocommerce_order_status_changed', 'update_lottery_ticket_selected', 10, 3);