<?php
$namespace = '/arka-custom-lottery-extension/v1';
$resource_name = 'products';
$schema = null;

function register_routes()
{
    global $namespace, $resource_name;
    register_rest_route($namespace, '/' . $resource_name, array(
        array(
            'methods' => 'GET',
            'callback' => 'get_items',
            'permission_callback' => '__return_true',
        ),
        'schema' => 'get_item_schema',
    ));

    register_rest_route($namespace, '/' . $resource_name . '/(?P<id>[\d]+)', array(
        array(
            'methods' => 'GET',
            'callback' => 'get_item',
            'permission_callback' => '__return_true',
        ),
        'schema' => 'get_item_schema',
    ));

    register_rest_route($namespace, '/' . $resource_name . '/generateNumbers/(?P<id>[\d]+)', array(
        array(
            'methods' => 'GET',
            'callback' => 'get_numbers',
            'permission_callback' => '__return_true',
        ),
        'schema' => 'get_item_schema',
    ));

    register_rest_route($namespace, '/' . $resource_name . '/enable-numbers/(?P<id>[\d]+)', array(
        array(
            'methods' => 'POST',
            'callback' => 'enable_numbers',
            'permission_callback' => '__return_true',
        ),
        'schema' => 'get_item_schema',
    ));
}

function get_items_permissions_check($request)
{
    if (!current_user_can('read')) {
        return new WP_Error('rest_forbidden', esc_html__('You cannot view the post resource.'), array('status' => authorization_status_code()));
    }
    return true;
}

/**
 * Grabs the five most recent posts and outputs them as a rest response.
 *
 * @param WP_REST_Request $request Current request.
 */
function get_items($request)
{
    $args = array(
        'post_per_page' => 5,
    );
    $posts = get_posts($args);

    $data = array();

    if (empty($posts)) {
        return rest_ensure_response($data);
    }

    foreach ($posts as $post) {
        $response = prepare_item_for_response($post, $request);
        $data[] = prepare_response_for_collection($response);
    }

    // Return all of our comment response data.
    return rest_ensure_response($data);
}

/**
 * Check permissions for the posts.
 *
 * @param WP_REST_Request $request Current request.
 */
function get_item_permissions_check($request)
{
    if (!current_user_can('read')) {
        return new WP_Error('rest_forbidden', esc_html__('You cannot view the post resource.'), array('status' => authorization_status_code()));
    }
    return true;
}

/**
 * Gets post data of requested post id and outputs it as a rest response.
 *
 * @param WP_REST_Request $request Current request.
 */
function get_item($request)
{
    $id = (int)$request['id'];
    $post = get_post($id);

    if (empty($post)) {
        return rest_ensure_response(array());
    }

    $response = prepare_item_for_response($post, $request);

    return $response;
}


/**
 * Gets post data of requested post id and outputs it as a rest response.
 *
 * @param WP_REST_Request $request Current request.
 */
function enable_numbers($request)
{
    global $wpdb;
    $listNumbers = $request['numbers'];

    if (empty($listNumbers)) {
        return rest_ensure_response(array());
    }


    foreach ($listNumbers as $number) {
        $wpdb->update(
            'wrif_lottery_selections',
            array(
                'status' => 'AVAILABLE',
            ),
            array(
                'id' => (int) $number['id']
            ),
            array(
                '%s',
            ),
            array( '%d' )
        );
    }
    return true;
}

function get_numbers($request)
{
    $id = (int)$request['id'];
    $ticket = (int)$request['ticket'];
    $post = get_post($id);

    if (empty($post)) {
        return rest_ensure_response(array());
    }

    $postInfo = prepare_item_for_response($post, $request);
    $response = get_random_numbers($postInfo, $ticket);
    return $response;
}

function get_random_numbers($postInfo, $ticket)
{
    global $wpdb;
    $inicio = $postInfo['meta_inicio_numeros'];
    $fin = $postInfo['meta_fin_numeros'];
    $cantidad = $postInfo['meta_cantidad_numeros'];
    $listNumbers = array();
    while (count($listNumbers) < $cantidad) {
        $selectedNumber = rand($inicio,$fin);
        $result = $wpdb->get_row("SELECT * FROM wrif_lottery_selections WHERE post_id = $postInfo[id] AND number = $selectedNumber AND status = 'AVAILABLE'");

        if(empty($result)){
            $wpdb->insert('wrif_lottery_selections', array(
                'post_id' => $postInfo['id'],
                'number' => $selectedNumber,
                'ticket_number' => $ticket,
                'date_selected' => date('Y-m-d H:i:s'),
                'status' => 'SELECTED',
            ));
            $result = $wpdb->get_row("SELECT * FROM wrif_lottery_selections WHERE id = $wpdb->insert_id");
        }

        array_push($listNumbers, $result);
    }

    return $listNumbers;
}

/**
 * Matches the post data to the schema we want.
 *
 * @param WP_Post $post The comment object whose response is being prepared.
 */
function prepare_item_for_response($post, $request)
{
    $post_data = array();

    $schema = get_item_schema($request);

    // We are also renaming the fields to more understandable names.
    if (isset($schema['properties']['id'])) {
        $post_data['id'] = (int)$post->ID;
    }

    if (isset($schema['properties']['content'])) {
        $post_data['content'] = apply_filters('the_content', $post->post_content, $post);
    }

    if (isset($schema['properties']['meta_inicio_numeros'])) {
        $post_data['meta_inicio_numeros'] = get_post_meta_product( $post->ID, 'meta_inicio_numeros', true );
    }

    if (isset($schema['properties']['meta_fin_numeros'])) {
        $post_data['meta_fin_numeros'] = get_post_meta_product( $post->ID, 'meta_fin_numeros', true );
    }

    if (isset($schema['properties']['meta_cantidad_numeros'])) {
        $post_data['meta_cantidad_numeros'] = get_post_meta_product( $post->ID, 'meta_cantidad_numeros', true );
    }

    return $post_data;
}


function get_post_meta_product( $post_id, $key, $single = true ) {
    return get_metadata( 'post', $post_id, $key, $single );
}

/**
 * Prepare a response for inserting into a collection of responses.
 *
 * This is copied from WP_REST_Controller class in the WP REST API v2 plugin.
 *
 * @param WP_REST_Response $response Response object.
 * @return array Response data, ready for insertion into collection data.
 */
function prepare_response_for_collection($response)
{
    if (!($response instanceof WP_REST_Response)) {
        return $response;
    }

    $data = (array)$response->get_data();
    $server = rest_get_server();

    if (method_exists($server, 'get_compact_response_links')) {
        $links = call_user_func(array($server, 'get_compact_response_links'), $response);
    } else {
        $links = call_user_func(array($server, 'get_response_links'), $response);
    }

    if (!empty($links)) {
        $data['_links'] = $links;
    }

    return $data;
}

/**
 * Get our sample schema for a post.
 *
 * @return array The sample schema for a post
 */
function get_item_schema($request)
{
    global $schema;
    if ($schema) {
        // Since WordPress 5.3, the schema can be cached in the $schema property.
        return $schema;
    }

    $schema = array(
        // This tells the spec of JSON Schema we are using which is draft 4.
        '$schema' => 'http://json-schema.org/draft-04/schema#',
        // The title property marks the identity of the resource.
        'title' => 'post',
        'type' => 'object',
        // In JSON Schema you can specify object properties in the properties attribute.
        'properties' => array(
            'id' => array(
                'description' => esc_html__('Unique identifier for the object.', 'my-textdomain'),
                'type' => 'integer',
                'context' => array('view', 'edit', 'embed'),
                'readonly' => true,
            ),
            'content' => array(
                'description' => esc_html__('The content for the object.', 'my-textdomain'),
                'type' => 'string',
            ),
            'meta_inicio_numeros' => array(
                'description' => esc_html__('Primer numero seleccionable', 'my-textdomain'),
                'type' => 'string',
            ),
            'meta_fin_numeros' => array(
                'description' => esc_html__('Ultimo numero seleccionable.', 'my-textdomain'),
                'type' => 'string',
            ),
            'meta_cantidad_numeros' => array(
                'description' => esc_html__('Cantidad de numeros aleatorios a generar.', 'my-textdomain'),
                'type' => 'string',
            )
        ),
    );

    return $schema;
}

// Sets up the proper HTTP status code for authorization.
function authorization_status_code()
{

    $status = 401;

    if (is_user_logged_in()) {
        $status = 403;
    }

    return $status;
}

add_action('rest_api_init', 'register_routes');