<?php
/**
 * Instant winners rule popup.
 *
 * @since 9.5.0
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.
$name = 'lty_instant_winner_rules[new]';
?>
<div class='lty-hide lty-lottery-instant-winners-rule-modal-wrapper' id='lty_lottery_instant_winners_rule_modal'>
	<div class='lty-instant-winners-rule-header'>
		<span class='lty-instant-winners-rule-title'><h3><b><?php esc_html_e( 'Instant Win Prizes', 'lottery-for-woocommerce' ); ?></b></h3></span>
	</div>
	<span class='lty-instant-winners-rule-error lty-error'></span>

	<table class='lty-instant-winners-rule-content'>
		<tr>
			<td>
				<p class='lty-lottery-ticket-number'>
					<label><b><?php esc_html_e( 'Ticket Number', 'lottery-for-woocommerce' ); ?></b><span class='required'>*</span></label>
					<input type='text' class='lty-ticket-number' id='lty_instant_winner_rule_ticket_number' name="<?php echo esc_attr( $name ); ?>[ticket_number]">
				</p>
				<p class='lty-ticket-prize-type'>
					<p>
						<label><b><?php esc_html_e( 'Prize Type', 'lottery-for-woocommerce' ); ?></b><span class='required'>*</span></label>
						<select name="<?php echo esc_attr( $name ); ?>[prize_type]" class='lty-instant-winner-prize-type'>
							<?php foreach ( lty_get_instant_winner_prize_type_options() as $option_key => $option_label ) : ?>	
								<option value="<?php echo esc_attr( $option_key ); ?>"><?php echo esc_html( $option_label ); ?></option>
							<?php endforeach; ?>
						</select>
					</p>
					<p>
						<select name="<?php echo esc_attr( $name ); ?>[coupon_generation_type]" class='lty-instant-winner-rule lty-instant-winner-prize-field lty-instant-winner-coupon-generation-type'>
							<?php foreach ( lty_get_instant_winner_coupon_generation_type_options() as $option_key => $option_label ) : ?>	
								<option value="<?php echo esc_attr( $option_key ); ?>"><?php echo esc_html( $option_label ); ?></option>
							<?php endforeach; ?>
						</select>
					</p>
					<p>
						<select name="<?php echo esc_attr( $name ); ?>[coupon_discount_type]" class='lty-instant-winner-rule lty-instant-winner-prize-field lty-instant-winner-coupon-field lty-instant-winner-coupon-discount-type'>
							<?php foreach ( lty_get_instant_winner_coupon_discount_type_options() as $option_key => $option_label ) : ?>	
								<option value="<?php echo esc_attr( $option_key ); ?>"><?php echo esc_html( $option_label ); ?></option>
							<?php endforeach; ?>
						</select>
					</p>
					<p>
						<?php
						lty_select2_html(
							array(
								'id'          => $name . '[coupon_id]',
								'class'       => 'lty-instant-winner-rule lty-instant-winner-prize-field lty-instant-winner-coupon-field lty-instant-winner-coupon-id',
								'action'      => 'lty_json_search_coupons',
								'placeholder' => __( 'Search for a coupon&hellip;', 'lottery-for-woocommerce' ),
								'multiple'    => false,
								'options'     => array(),
							)
						);
						?>
					</p>
					<p>
					<input type='text' class='wc_input_price lty-instant-winner-rule lty-instant-winner-prize-field lty-instant-winner-coupon-field lty-instant-winner-prize-amount' name="<?php echo esc_attr( $name ); ?>[prize_amount]" value=''>
					</p>
				</p>
				<p class='lty-lottery-ticket-prize'>
					<label><b><?php esc_html_e( 'Prize', 'lottery-for-woocommerce' ); ?></b><span class='required'>*</span></label>				
					<textarea class='lty-instant-winner-rule lty-instant-winner-prize-message' name="<?php echo esc_attr( $name ); ?>[prize_message]"></textarea>
				</p>
				<p class='lty-instant-winner-image'>
					<label><b><?php esc_html_e( 'Image', 'lottery-for-woocommerce' ); ?></b></label>
					<span class='lty-instant-winner-image-preview'><img src="<?php echo esc_url( wc_placeholder_img_src() ); ?>" height='45px' width='45px' /></span>
					<input type='hidden' name="<?php echo esc_attr( $name ); ?>[image_id]" class='lty-instant-winner-image-id' value=''/>
					<button class='button lty-instant-winner-rule lty-select-image'><?php esc_attr_e( 'Choose Image', 'lottery-for-woocommerce' ); ?></button>
					<button class='button lty-instant-winner-rule lty-remove-image' style='display: none;'><?php esc_attr_e( 'Remove', 'lottery-for-woocommerce' ); ?></button>
				</p>
			</td>
		</tr>
	</table>
	<div class='lty-instant-winners-rule-footer'>
		<input type='button' class='button button-primary lty-add-instant-winner-rule' value="<?php esc_html_e( 'Create', 'lottery-for-woocommerce' ); ?>">
	</div>
</div>
<?php
