<?php
/**
 * Import - Upload form.
 *
 * @since 9.9.0
 */
defined('ABSPATH') || exit; // Exit if accessed directly.
?>
<form id='lty_import_form' method='POST' enctype='multipart/form-data'>
	<table class='lty-import-upload-table'>
		<tr>
			<th><?php esc_html_e('Choose a CSV file from your computer:', 'lottery-for-woocommerce'); ?></th>
			<td>
				<input type='file' id='lty_import_file' name='import' accept='.csv,.txt'/>
				<input type='hidden' id='lty_import_max_file_size' value='<?php echo esc_attr($this->get_wp_max_upload_size()); ?>'/>
				<br>
				<small>
					<?php
					printf(
							/* translators: %s: maximum upload size */
							esc_html__('Maximum size: %s', 'lottery-for-woocommerce'),
							esc_html(size_format($this->get_wp_max_upload_size()))
					);
					?>
				</small>
			</td>
		</tr>
	</table>
</form>

<?php if ($this->get_upload_file_description()) : ?>
	<p class='lty-upload-file-description'>
	<?php
		printf(
				/* translators: %s: description */
				wp_kses_post(__('<b>Note :</b> %s', 'lottery-for-woocommerce')),
				wp_kses_post($this->get_upload_file_description())
										   );
	?>
	</p>
<?php endif; ?>

<footer class='wc-backbone-modal-footer'>
	<a class='lty-upload-form button button-primary'><?php esc_html_e('Continue', 'lottery-for-woocommerce'); ?></a>
</footer>
<?php
